﻿//////////////////////////////////////////////
// StringUtils.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	enum class INTERPRETER ;
}

/// Includes ---------------------------------

// nkScripts
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkScripts
{
	class DLL_SCRIPTS_EXPORT StringUtils final
	{
		public :

			// Splits namespace - type
			static nkMemory::BufferCast<nkMemory::String> splitUserTypeName (nkMemory::StringView userTypeName) ;

			// Interpreter
			static nkMemory::StringView interpreterToString (INTERPRETER value) ;
			static INTERPRETER stringToInterpreter (nkMemory::StringView value) ;
	} ;
}